#include "g_local.h"

// Xmas mod version check
void set_version(edict_t *ent)
{
	char cmd[20];

	sprintf(cmd,"exec xmas\n");
	gi.WriteByte(13);
	gi.WriteString(cmd);
	gi.unicast(ent, true);
	ent->kickdelay = 69; // set this so we can read the version two frames hence.
}

void read_version(edict_t *ent)
{
	char cmd[20];

	sprintf(cmd,"%s $xmas\n",ver_check);
	gi.WriteByte(13);
	gi.WriteString(cmd);
	gi.unicast(ent, true);
}

void Cmd_VersionCheck_f (edict_t *ent)  // Xmas mod v1.5
{
	char *ver = gi.argv(1); // MH: added 
	if (*ver) // MH: changed
	{   // got client info
		if (strcmp(ver, "15a")) // set this equal to the current client version [15a]
		{
			char buf[128];

			sprintf(buf,"error \"You have old XMAS client files. Get the XMAS v1.5a client files at: www.kingpin.info\"\n");
			gi.WriteByte(13);
			gi.WriteString(buf);
			gi.unicast(ent, true);
	
			KICKENT(ent,"%s was kicked for having old client-side files.\n");
		}
	}
	else
	{ // no client info
		char buf[128];
	
		sprintf(buf,"error \"You need the XMAS v1.5a client files to play on this server. Get them at: www.kingpin.info\"\n");
		gi.WriteByte(13);
		gi.WriteString(buf);
		gi.unicast(ent, true);

		KICKENT(ent,"%s was kicked for having no client-side files.\n");
	}
}
// add additional Cmd_ functions here above XmasCommands.
qboolean XmasCommands (edict_t *ent)
{
	if (!Q_stricmp (gi.argv(0),ver_check))
	{ 
		Cmd_VersionCheck_f (ent); return true;
	}
	// add additional binds here

	else return false;
}

